/*****************************************************************************
*  LPC43xx SCT demo program
*
*  Use SCT timer to generate 2 PWM signals with different
*  dutycycles @ SCT_OUT0 (pin P2_8) and SCT_OUT1 (pin P2_7)
*****************************************************************************/
#include "nxp_lpc43xx.h"
#include "mcb4300.h"

extern void SCT_Init(void);

int main (void)
{
    SystemCoreClockUpdate ();                      // Update system core clock

    LPC_CCU1->CLK_M4_SCT_CFG  = (1 << 0);          // enable SCT clock in CCU1 

    MCB4300_Init();                                // Initialize MCB4300 board stuff
    SCT_Init();                                    // Initialize SCT1

    while (1)                                      // loop forever
    {
    }
}
